	function [Glp, Zlp, Plp] = PZ_2_LP_Z(G, Z, P, OmegaT, wcT)
	
	% 	Transforms the poles and zeros of a digital lowpass filter with   
	% 	cutoff frequency, OmegaT, to a lowpass filter the passband edge wcT
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% Author: 			Lars Wanhammar 2004-09-22
	% Modified by: 		 
	% 	Copyright:		by authors - not released for commercial use
	% Version: 			1
	% Known bugs: 
	% Report bugs to:	Wanhammar@gmail.com
	
	alpha = sin((OmegaT-wcT)/2)/sin((OmegaT+wcT)/2);
	
	% Transform LP zeros to LP zeros
	Zlp =  (Z+alpha)./(1+alpha*Z);
	
	% Transform LP poles to LP poles	
	Plp =  (P+alpha)./(1+alpha*P);
	
	Glp = real(G*real(prod(1+alpha*Z)/prod(1+alpha*P)));	
	
